/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.editores;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.logger.PluginLogger;
import ec.gob.sri.dimm.api.modelo.persistencia.AdministradorPersistencia;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.ui.dialogos.DialogoMensajes;
import ec.gob.sri.dimm.api.ui.editores.EditorBase;
import ec.gob.sri.dimm.ats.modelo.impl.AdministradorModeloATS;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.asistente.valores.TipoDeclaracion;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import ec.gob.sri.dimm.ats.modelo.util.XmlCleanUp;
import ec.gob.sri.dimm.ats.ui.editores.InputEditorATS;
import ec.gob.sri.dimm.ats.ui.editores.InputEditorErroresInformacionATS;
import ec.gob.sri.dimm.ats.ui.editores.InputEditorTalonATS;
import ec.gob.sri.dimm.ats.ui.operaciones.OperacionValidacionAnexo;
import ec.gob.sri.dimm.ats.ui.paginas.PaginaAnulados;
import ec.gob.sri.dimm.ats.ui.paginas.PaginaCompras;
import ec.gob.sri.dimm.ats.ui.paginas.PaginaExportaciones;
import ec.gob.sri.dimm.ats.ui.paginas.PaginaFideicomisos;
import ec.gob.sri.dimm.ats.ui.paginas.PaginaRecaps;
import ec.gob.sri.dimm.ats.ui.paginas.PaginaRendimientos;
import ec.gob.sri.dimm.ats.ui.paginas.PaginaVentas;
import ec.gob.sri.dimm.ats.validacion.talon.TalonResumenATS;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.w3c.dom.Document;

public class EditorATS
extends EditorBase<Iva, InputEditorATS> {
    public static final String ID = "ec.gob.sri.dimm.ats.ui.editores.EditorATS";
    private static final String PAG_COMPRAS = "p_PagCompras";
    private static final String PAG_VENTAS = "p_PagVentas";
    private static final String PAG_EXPORTACIONES = "p_PagExportaciones";
    private static final String PAG_ANULADOS = "p_PagAnulados";
    private static final String PAG_RECAPS = "p_PagRecaps";
    private static final String PAG_RENDIMIENTOS = "p_PagRendimientos";
    private static final String PAG_FIDEICOMISOS = "p_PagFideicomisos";
    private static final String PATH_EXPORTACIONES = "atsExport";
    private static final String FIL_LAST_EXPORT = "lastExportXml.xml";
    private boolean puedeGenerarTalon = false;
    private String pathLastFileXml = "";

    protected void addPages() {
        PaginaCompras pCompras = new PaginaCompras(this, PAG_COMPRAS, "Compras");
        pCompras.setModeloDatos((Iva)this.modeloDatos);
        PaginaVentas pVentas = new PaginaVentas(this, PAG_VENTAS, "Ventas");
        pVentas.setModeloDatos((Iva)this.modeloDatos);
        PaginaExportaciones pExportaciones = new PaginaExportaciones(this, PAG_EXPORTACIONES, "Exportaciones y otros ingresos del exterior");
        pExportaciones.setModeloDatos((Iva)this.modeloDatos);
        PaginaAnulados pAnulados = new PaginaAnulados(this, PAG_ANULADOS, "Comprobantes Anulados");
        pAnulados.setModeloDatos((Iva)this.modeloDatos);
        PaginaRecaps pRecaps = new PaginaRecaps(this, PAG_RECAPS, "RECAPS");
        pRecaps.setModeloDatos((Iva)this.modeloDatos);
        PaginaRendimientos pRendimientos = new PaginaRendimientos(this, PAG_RENDIMIENTOS, "Rendimientos");
        pRendimientos.setModeloDatos((Iva)this.modeloDatos);
        PaginaFideicomisos pFideicomisos = new PaginaFideicomisos(this, PAG_FIDEICOMISOS, "Fideicomisos");
        pFideicomisos.setModeloDatos((Iva)this.modeloDatos);
        try {
            this.addPage((IFormPage)pCompras);
            this.addPage((IFormPage)pVentas);
            this.addPage((IFormPage)pExportaciones);
            this.addPage((IFormPage)pAnulados);
            if (((InputEditorATS)this.datosInput).getTipo().equals((Object)TipoDeclaracion.TIPO2)) {
                this.addPage((IFormPage)pRecaps);
                this.addPage((IFormPage)pRendimientos);
                this.addPage((IFormPage)pFideicomisos);
            }
            this.setActivePage(PAG_COMPRAS);
        }
        catch (PartInitException e) {
            PluginLogger.logError((String)"Error al inicializar el editor.", (String)"ec.gob.sri.dimm.ats.ui", (Exception)((Object)e));
        }
    }

    protected List<Action> crearAccionesGenerales() {
        ArrayList<Action> acciones = new ArrayList<Action>();
        acciones.add(new Action("Generar XML"){

            public void run() {
                AdministradorModeloATS adminModelo = new AdministradorModeloATS();
                ResultadoValidacion resultado = adminModelo.validarAnexo((Iva)EditorATS.this.modeloDatos);
                if (resultado.tieneVariosErrores()) {
                    DialogoMensajes dMensajes = new DialogoMensajes(EditorATS.this.getSite(), "Anexo Transaccional", resultado.getMensajes());
                    dMensajes.create();
                    dMensajes.open();
                } else {
                    OperacionValidacionAnexo operacionValidacion;
                    String rutaTemporalXML = AdministradorPersistencia.generarRutaArchivoXMLTemporal();
                    File archivoXMLTemporal = new File(rutaTemporalXML);
                    Document documentoFinal = adminModelo.exportar((Iva)EditorATS.this.modeloDatos);
                    documentoFinal = new XmlCleanUp().clean(documentoFinal);
                    AdministradorPersistencia.generarXML((String)rutaTemporalXML, (Document)documentoFinal);
                    try {
                        operacionValidacion = EditorATS.this.ejecutarValidaciones(archivoXMLTemporal);
                    }
                    catch (InvocationTargetException e) {
                        PluginLogger.logError((String)"Error inesperado al validar el anexo.", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e);
                        EditorATS.this.mostrarError("El archivo no cumple con las especificaciones t\u00e9cnicas establecidas para el anexo");
                        return;
                    }
                    catch (InterruptedException e) {
                        PluginLogger.logError((String)"Proceso de validacion interrumpido.", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e);
                        EditorATS.this.mostrarError("Se ha producido un error en el anexo.");
                        return;
                    }
                    Boolean errores = EditorATS.this.muestraErrores(operacionValidacion, archivoXMLTemporal);
                    if (errores.booleanValue()) {
                        EditorATS.this.respaldoFuenteDatosTalonResumen(archivoXMLTemporal);
                        EditorATS.this.mostrarInformacion(String.format("El anexo fue validado exitosamente.%n%nProceso Finalizado", new Object[0]));
                        EditorATS.this.guardarAnexoDefinitivo(documentoFinal);
                    }
                }
            }
        });
        return acciones;
    }

    protected void guardarAnexoDefinitivo(Document documentoFinal) {
        FileDialog saveDialog = new FileDialog(this.getEditorSite().getShell(), 8192);
        saveDialog.setFilterNames(new String[]{"Archivos XML"});
        saveDialog.setFilterExtensions(new String[]{"*.xml"});
        saveDialog.setText("Guardar");
        saveDialog.setFileName("AT-" + ((Iva)this.modeloDatos).getDatosDeclaracion().getMes() + ((Iva)this.modeloDatos).getDatosDeclaracion().getAnio() + ".xml");
        String rutaFinal = saveDialog.open();
        if (!StringUtil.isNullOrEmpty((String)rutaFinal)) {
            File archivoFinal;
            String extension = "";
            if (!rutaFinal.toUpperCase().endsWith(".XML")) {
                extension = ".xml";
            }
            if ((archivoFinal = new File(String.valueOf(rutaFinal) + extension)).exists()) {
                if (this.mostrarConfirmacion("El archivo ya existe. \u00bfDesea sobreescribirlo?")) {
                    archivoFinal.delete();
                } else {
                    this.mostrarInformacion("Exportaci\u00f3n cancelada.");
                    return;
                }
            }
            AdministradorPersistencia.generarXML((String)archivoFinal.getAbsolutePath(), (Document)documentoFinal);
            this.mostrarInformacion("Archivo generado exitosamente.");
            this.pathLastFileXml = archivoFinal.getAbsolutePath();
            this.puedeGenerarTalon = true;
            this.generarYmostarTalonResumen();
        }
    }

    protected void respaldoFuenteDatosTalonResumen(File archivoXMLTemporal) {
        try {
            Util.moveFile((String)Util.obtenerRutaBajoDimmHome((String)PATH_EXPORTACIONES), (String)FIL_LAST_EXPORT, (File)archivoXMLTemporal);
            PluginLogger.logError((String)"Se movio el archivo", (String)"ec.gob.sri.dimm.ats.ui");
        }
        catch (IOException e) {
            PluginLogger.logError((String)"Error mover el archivo XML", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e);
        }
    }

    protected Boolean muestraErrores(OperacionValidacionAnexo operacionValidacion, File archivoXMLTemporal) {
        PluginLogger.logInfo((String)"muestraErrores", (String)"ec.gob.sri.dimm.ats.ui");
        ResultadoValidacion resultadoEsquema = operacionValidacion.getResultadoValidacionEsquema();
        if (resultadoEsquema != null && (resultadoEsquema.tieneVariosErrores() || resultadoEsquema.tieneVariasAdvertencias())) {
            PluginLogger.logInfo((String)"Advertencias o errores de ESQUEMA", (String)"ec.gob.sri.dimm.ats.ui");
            DialogoMensajes mensajesEsquema = new DialogoMensajes(this.getSite(), "Anexo Transaccional", resultadoEsquema.getMensajes());
            mensajesEsquema.open();
            return Boolean.FALSE;
        }
        File archivoErroresValidacion = operacionValidacion.getArchivoErroresInformacion();
        if (archivoErroresValidacion != null) {
            PluginLogger.logInfo((String)"Errores de validacion", (String)"ec.gob.sri.dimm.ats.ui");
            InputEditorErroresInformacionATS datosInput = new InputEditorErroresInformacionATS(archivoErroresValidacion, archivoXMLTemporal);
            try {
                this.getSite().getPage().openEditor((IEditorInput)datosInput, "ec.gob.sri.dimm.ats.ui.editores.EditorErroresInformacionATS");
            }
            catch (PartInitException e) {
                this.mostrarError("Se ha producido un problema al abrir el visor de errores de validaci\u00f3n: ");
                PluginLogger.logError((String)"Error al mostrar errores de validacion de informacion", (String)"ec.gob.sri.dimm.ats.ui", (Exception)((Object)e));
                return Boolean.FALSE;
            }
            if (operacionValidacion.isTieneErrores()) {
                PluginLogger.logInfo((String)"Tiene Errores de validacion", (String)"ec.gob.sri.dimm.ats.ui");
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    protected OperacionValidacionAnexo ejecutarValidaciones(File archivoXMLTemporal) throws InvocationTargetException, InterruptedException {
        ProgressMonitorDialog pmValidar = new ProgressMonitorDialog(this.getSite().getShell());
        OperacionValidacionAnexo operacionValidacion = new OperacionValidacionAnexo(archivoXMLTemporal);
        pmValidar.run(true, false, (IRunnableWithProgress)operacionValidacion);
        return operacionValidacion;
    }

    protected void generarYmostarTalonResumen() {
        block7: {
            if (this.puedeGenerarTalon) {
                PluginLogger.logInfo((String)("Generando Talon del archivo:" + this.pathLastFileXml), (String)"ec.gob.sri.dimm.ats.ui");
                File xmlFile = new File(this.pathLastFileXml);
                try {
                    TalonResumenATS talon = new TalonResumenATS(xmlFile);
                    File talonFile = talon.generarTalonCompletoDIMM();
                    String OS = System.getProperty("os.name");
                    if (OS.indexOf("nix") != -1 || OS.indexOf("nux") != -1 || OS.indexOf("aix") != -1) {
                        this.verBrowserUnix(talonFile.getPath());
                        break block7;
                    }
                    if (OS.indexOf("Mac") != -1) {
                        this.verBrowserMac(talonFile.getPath());
                        break block7;
                    }
                    InputEditorTalonATS inpEdTal = new InputEditorTalonATS(talonFile);
                    this.getSite().getPage().openEditor((IEditorInput)inpEdTal, "ec.gob.sri.dimm.ats.ui.editores.EditorTalonATS");
                    this.puedeGenerarTalon = Boolean.FALSE;
                }
                catch (PartInitException partInitException) {
                    this.mostrarError("Se ha producido un error al abrir el tal\u00f3n de resumen.");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.mostrarError("Se ha producido un error al generar el tal\u00f3n de resumen.");
                }
            } else {
                this.mostrarError("No se puede generar el Tal\u00f3n de Resumen sin haber exportado previamente el Archivo XML");
            }
        }
    }

    private void verBrowserMac(String url) {
        try {
            Runtime.getRuntime().exec("open " + url);
        }
        catch (Exception e) {
            PluginLogger.logError((String)"Error general al abrir Talon Resumen en el browser: ", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e);
        }
    }

    private void verBrowserUnix(String url) {
        String browser = null;
        try {
            String[] browsers = new String[]{"firefox", "iceweasel", "chrome", "opera", "konqueror", "epiphany", "mozilla", "netscape", "chromium"};
            int count = 0;
            while (count < browsers.length && browser == null) {
                if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() == 0) {
                    browser = browsers[count];
                    break;
                }
                ++count;
            }
            if (browser == null) {
                this.mostrarError("No se encontro un browser compatible. Favor primero instale algunos de estos navegadores:\n Firefox, Iceweasel, Chrome, Opera, Konkeror, Epiphany, Chromium o Netscape");
                PluginLogger.logError((String)"No se encontro un browser compatible", (String)"ec.gob.sri.dimm.ats.ui");
                throw new RuntimeException("No se encontro un browser compatible");
            }
            Runtime.getRuntime().exec(new String[]{browser, url});
        }
        catch (Exception e) {
            PluginLogger.logError((String)("Error general al abrir Talon Resumen en el browser: " + browser), (String)"ec.gob.sri.dimm.ats.ui", (Exception)e);
        }
    }

    public AdministradorPersistencia<Iva> obtenerAdministradorPersistencia() {
        if (this.administradorPersistencia == null) {
            this.administradorPersistencia = new AdministradorPersistencia(((Iva)this.modeloDatos).getIdentificacion(), ((Iva)this.modeloDatos).getDatosDeclaracion().getAnio(), ((Iva)this.modeloDatos).getDatosDeclaracion().getMes());
        }
        return this.administradorPersistencia;
    }
}

